@extends('layouts.master')

@section('title')
    تقرير الحضور  والغيابللدورة التدريبية
@endsection

@section('first-css')
@endsection

@section('content-body')
    <!--**********************************
                            Content body start
                        ***********************************-->
    @include('massages')
@section('route-path')
    <div class="container-fluid container-fluid-traning px-0">
        <div class="d-flex flex-wrap align-items-end justify-content-between  mb-3">
            <h1>
                تقرير الحضور  والغيابللدورة التدريبية
            </h1>
            <div class="link">
                <a href="" class="px-4 ">عرض تقرير الحضور والغياب
                </a>
            </div>
        </div>
    </div>
@endsection
<!-- row -->
<div class="container-fluid container-fluid-traning bg-white">
    <!--**********************************Tabs Start***********************************-->
    <div class="d-flex flex-wrap align-items-start justify-content-start  mb-3">
        <button type="button" class="btn btn-primary  me-1" data-bs-toggle="modal" data-bs-target="#addEvaluation">
            <i class="mdi mdi-plus-circle ms-2"></i> تصدير
        </button>
    </div>
    <!--**********************************Tabs End***********************************-->
    <div class="row">
        <div class="col-xl-12 tab-content">
            <!--**********************************Table AllTransaction Start***********************************-->

            <div class="tab-pane fade show active" id="AllTransaction" role="tabpanel"
                aria-labelledby="transaction-tab">
                <div class="table-responsive fs-14">
                    <table class="table card-table display mb-4 dataTablesCard text-black text-center" id="example">
                        <thead>
                            <tr>
                                <th>رقم </th>
                                <th>اسم المتدرب </th>
                                <th>نسبة الحضور</th>
                                <th>نسبة الغياب</th>
                                <th>نسبة الدروس الغير منجزة</th>

                            </tr>
                        </thead>
                        <tbody>
                            @isset($rooms)
                                @foreach ($rooms as $room)
                                    <tr class="odd" role="row">
                                        <td>
                                            @isset($room)
                                                {{ $loop->iteration }}
                                            @endisset
                                        </td>
                                        <td>
                                            @isset($room->student->name)
                                                {{ $room->student->name }}
                                            @endisset
                                        </td>

                                        <td>
                                            @isset($room->presentsPercentage)
                                                {{ $room->presentsPercentage }}
                                            @else
                                                0
                                            @endisset
                                                %
                                        </td>
                                        <td>
                                            @isset($room->absentsPercentage)
                                                {{ $room->absentsPercentage }}
                                            @else
                                                0
                                            @endisset
                                                %
                                        </td>
                                        <td>
                                            @isset($room->notAttendantPercentage)
                                                {{ $room->notAttendantPercentage }}
                                            @else
                                                0
                                            @endisset
                                                %
                                        </td>

                                    </tr>
                                @endforeach
                            @endisset
                        </tbody>
                    </table>
                </div>
            </div>
            <!--**********************************Table AllTransaction End***********************************-->
        </div>
    </div>

</div>

<div class="container-fluid">
    <div class="row row-cols-1 row-cols-md-3 justify-content-around">
        <div class="card text-white bg-white mb-3 col-10 col-lg-5">
            <div class="card-body d-flex row">
                <div class="col-md-12 col-lg-5 col-xl-5 col-sm-12 d-flex flex-column justify-content-start">
                    <div class="d-flex justify-content-start align-items-center mb-2 mt-4">
                        <div class="color-pointer bg-excellent"></div>
                        <div class="text-primary pe-2">ممتاز <span>@isset($evaluationCount['content']['excellent']){{$evaluationCount['content']['excellent']}}@endisset%</span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-v-good"></div>
                        <div class="text-primary pe-2">جيد جدا <span>@isset($evaluationCount['content']['good']){{$evaluationCount['content']['good']}}@endisset%</span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-good"></div>
                        <div class="text-primary pe-2">جيد <span>@isset($evaluationCount['content']['good']){{$evaluationCount['content']['good']}}@endisset%</span></div>
                    </div>

                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer"></div>
                        <div class="text-primary pe-2">مقبول <span>@isset($evaluationCount['content']['week']){{$evaluationCount['content']['week']}}@endisset%</span></div>
                    </div>
                </div>
                <div class="col-md-12 col-lg-7 col-xl-7 col-sm-12">

                    <div  style="
                        width: 150px; height: 150px;
                        border-radius: 50%;
                        margin:auto;

                        background: conic-gradient(
                            #23c099 0deg 50deg,
                            #c02323 50deg 90deg,
                            #b37053 90deg 100deg,
                            #35537d 100deg 360deg
                        );">
                    </div>
                <h5 class="text-center text-primary mt-2">محتوى الدورة</h5>
                </div>
            </div>
        </div>
        <div class="card text-white bg-white mb-3 col-10 col-lg-5">
            <div class="card-body d-flex row">
                <div class="col-md-12 col-lg-5 col-xl-5 col-sm-12 d-flex flex-column justify-content-start">
                    <div class="d-flex justify-content-start align-items-center mb-2 mt-4">
                        <div class="color-pointer bg-excellent"></div>
                        <div class="text-primary pe-2">ممتاز <span>@isset($evaluationCount['content']['excellent']){{$evaluationCount['content']['excellent']}}@endisset%</span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-v-good"></div>
                        <div class="text-primary pe-2">جيد جدا <span>@isset($evaluationCount['content']['good']){{$evaluationCount['content']['good']}}@endisset%</span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-good"></div>
                        <div class="text-primary pe-2">جيد <span>@isset($evaluationCount['content']['good']){{$evaluationCount['content']['good']}}@endisset%</span></div>
                    </div>

                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer"></div>
                        <div class="text-primary pe-2">مقبول <span>@isset($evaluationCount['content']['week']){{$evaluationCount['content']['week']}}@endisset%</span></div>
                    </div>
                </div>
                <div class="col-md-12 col-lg-7 col-xl-7 col-sm-12">

                    <div  style="
                        width: 150px; height: 150px;
                        border-radius: 50%;
                        margin:auto;

                        background: conic-gradient(
                            #23c099 0deg 50deg,
                            #c02323 50deg 90deg,
                            #b37053 90deg 100deg,
                            #35537d 100deg 360deg
                        );">
                    </div>
                <h5 class="text-center text-primary mt-2">محتوى الدورة</h5>
                </div>
            </div>
        </div>
        <div class="card text-white bg-white mb-3 col-10 col-lg-5">
            <div class="card-body d-flex row">
                <div class="col-md-12 col-lg-5 col-xl-5 col-sm-12 d-flex flex-column justify-content-start">
                    <div class="d-flex justify-content-start align-items-center mb-2 mt-4">
                        <div class="color-pointer bg-excellent"></div>
                        <div class="text-primary pe-2">ممتاز <span>@isset($evaluationCount['content']['excellent']){{$evaluationCount['content']['excellent']}}@endisset%</span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-v-good"></div>
                        <div class="text-primary pe-2">جيد جدا <span>@isset($evaluationCount['content']['good']){{$evaluationCount['content']['good']}}@endisset%</span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-good"></div>
                        <div class="text-primary pe-2">جيد <span>@isset($evaluationCount['content']['good']){{$evaluationCount['content']['good']}}@endisset%</span></div>
                    </div>

                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer"></div>
                        <div class="text-primary pe-2">مقبول <span>@isset($evaluationCount['content']['week']){{$evaluationCount['content']['week']}}@endisset%</span></div>
                    </div>
                </div>
                <div class="col-md-12 col-lg-7 col-xl-7 col-sm-12">

                    <div  style="
                        width: 150px; height: 150px;
                        border-radius: 50%;
                        margin:auto;

                        background: conic-gradient(
                            #23c099 0deg 50deg,
                            #c02323 50deg 90deg,
                            #b37053 90deg 100deg,
                            #35537d 100deg 360deg
                        );">
                    </div>
                <h5 class="text-center text-primary mt-2">محتوى الدورة</h5>
                </div>
            </div>
        </div>


    </div>
</div>
<!--**********************************
                        Content body end
            ***********************************-->
@endsection
@section('script')
@endsection
